<?php

	global $params;
	
	$params['prefix_list'] = array('en');		// ex. array('en','jp',...)
	$params['hook']['after_read_page'][] = 'after_read_page_multi_language';
	$params['hook']['before_modified'][] = 'my_after_modified';

	function after_read_page_multi_language(&$page_ar) {
		global $html,$params,$ut;
		if ($page_ar['block_type'] == 5) {
			return;
		}
		$lang = trim($params['url_prefix'],' /');
		$edit_mode = isset($_GET['mode']) && $_GET['mode'] == 'edit';
		$k = array_search($lang,$params['prefix_list']);
		$google_translator = false;
		if ($k !== false) {
			$params['circle']['name'] = '***** site name *****';
			if (isset($page_ar['meta']['lang'][$lang]['title'])) {
				$page_ar['title'] = $page_ar['meta']['lang'][$lang]['title'];
				$page_ar['description'] = '';	//descriptionの現地語化は複雑になるため割り切る
			}
			if (isset($page_ar['meta']['draft'])) {
				$v = $page_ar['meta']['draft'];
				$v = preg_replace("/<font.*?>(.*?)<\\/font>/", '${1}', $v);
				$v = preg_replace("/<font.*?>(.*?)<\\/font>/", '${1}', $v);
				function after_read_page_multi_language_repl($matches) {
					$v = str_replace(' ','',$matches[2]);
					return '$'.strtolower($v).$matches[3];
				}
				$v = preg_replace_callback("/(\\$)([A-z ]+?)([ (]+?)/", 'after_read_page_multi_language_repl', $v);
				$v = preg_replace_callback("/(\\$ )([Uu]t-\\>[A-z ]+?)([ (]+?)/", 'after_read_page_multi_language_repl', $v);
				$v = preg_replace_callback("/(\\$ )([Uu]t-&gt;[A-z ]+?)([ (]+?)/", 'after_read_page_multi_language_repl', $v);
				$page_ar['meta']['draft'] = $v;
			} else if (isset($page_ar['meta']['lang'][$lang]['contents'])) {
				my_snippet_breadcrumb( $lang, $params['page']['link'], adjust_mstring($params['page']['title']) );
				$page_ar['contents'] = $page_ar['meta']['lang'][$lang]['contents'];
				if (!$edit_mode) {
					$page_ar['contents'] .= "<p style='padding-top:30px;font-size:50%;font-weight:bold;'><a href='https://translate.google.com/manager/website/'>Google Website Translator - Google Translate</a></p>";
				}
			} else {
				$google_translator = true;
				if (!$edit_mode) {
					// $page_ar['contents'] = "<p style='color:red'>This page has not been translated yet.</p>".$page_ar['contents'];
				} else {
					$params['hide-editmenu'] = true;
$params['add-editmenu'][] = <<<EOT
					<input type='button' class='onethird-button mini' value='Fetch' onclick='ot.fetch_translation()' />
EOT;
$html['meta'][] = <<<EOT
					<script>
						\$(function(){
							ot.fetch_translation = function(){
								ot.reset_moving();
								var html = ot.tryitEditor.html();
								var title = \$("#edit_title").text();
								ot.ajax({
									type: "POST"
									, url: '{$_SERVER['REQUEST_URI']}'
									, data: "ajax=fetch_translation&editdata="+encodeURIComponent(html)+"&title="+encodeURIComponent(title)
									, dataType:'json'
									, success: function(data){
										if (data && data['result']) {
											location.reload(true);
										} else {
											alert('Save failed');
										}
									}
								});
							};
						});
					</script>
EOT;
				}
				if (isset($_POST['ajax']) && $_POST['ajax'] == 'fetch_translation')  {
					$r = array();
					$r['id'] = $params['page']['id'];
					$r['meta']['draft'] = sanitize_html($_POST['editdata']);
					$r['meta']['lang'][$lang]['title'] =  sanitize_str($_POST['title']);
					$r['result'] = mod_data_items($r);
					echo( json_encode($r) );
					exit();
				}
			}
			if ($edit_mode) {
$params['add-editmenu'][] = <<<EOT
				<input type='button' class='onethird-button mini' value='Reset' onclick='ot.reset_translation()' />
EOT;
$html['meta'][] = <<<EOT
				<script>
					\$(function(){
						ot.reset_translation = function(){
							var opt = "ajax=reset_translation";
							ot.ajax({
								type: "POST"
								, url: '{$_SERVER['REQUEST_URI']}'
								, data: opt
								, dataType:'json'
								, success: function(data){
									if ( data && data['result'] ) {
										location.reload(true);
									} else {
										alert('error');
									}
								}
							});
						};
					});
				</script>
EOT;
				if (isset($_POST['ajax']) && $_POST['ajax'] == 'reset_translation')  {
					$r = array();
					$r['id'] = $params['page']['id'];
					unset($params['page']['meta']['lang'][$lang]['title']);
					unset($params['page']['meta']['lang'][$lang]['contents']);
					unset($params['page']['meta']['draft']);
					$r['metadata'] = serialize64($params['page']['meta']);
					$r['result'] = mod_data_items($r);
					echo( json_encode($r) );
					exit();
				}
			}
			$params['hook']['before_modified'][] = 'before_modified_page_multi_language';

			if ($google_translator) {
				//https://translate.google.com/manager/website/
$html['article']['google_translator'] =  <<<EOT

				**************** google code ******************

EOT;
			}

			$params['add-blockmenu']['google_translator'] = "<input type='button' value='show org' class='onethird-button mini' onclick='location.href=\"{$ut->link($page_ar['id'],"prefix:")}\"' />";

		} else {
			if (check_rights() && isset($page_ar['id']) && isset($params['prefix_list'][0]) && $page_ar['block_type']==1) {
				$x = 'create ';
				if (isset($page_ar['meta']['lang'][$params['prefix_list'][0]]['contents'])) {
					$x = 'show ';
				}
				$params['add-blockmenu']['google_translator'] = "<input type='button' value='{$x}{$params['prefix_list'][0]}' class='onethird-button mini' onclick='location.href=\"{$ut->link($page_ar['id'],"prefix:{$params['prefix_list'][0]}/")}\"' />";
			}
		}
	}
	function before_modified_page_multi_language(&$new_ar) {
		global $params,$ut;
		if (isset($_POST['draft'])) {
			return true;
		}
		$lang = trim($params['url_prefix'],' /');
		
		$new_ar['meta']['lang'][$lang]['contents'] = $new_ar['contents'];
		unset($new_ar['contents']);

		$new_ar['meta']['lang'][$lang]['title'] = $new_ar['title'];
		unset($new_ar['title']);

		$new_ar['metadata'] = serialize64($new_ar['meta']);
		unset($new_ar['meta']);
		if (mod_data_items($new_ar)) {
			if (isset($params['top_page'])) {
				header("Location: {$ut->link()}");
				
			} else {
				if ($new_ar['block_type'] == 5) {
					header("Location: {$ut->link($new_ar['link'])}");
				} else {
					header("Location: {$ut->link($new_ar['id'])}");
				}
			}
			exit();
		}
		exit_proc(400, 'Save-Error');
	}
	function my_after_modified(&$new_ar) {
		global $params;
		$lang = trim($params['url_prefix'],' /');
		if (!$lang && isset($new_ar['meta']['lang'])) {
			if (isset($new_ar['meta']['lang'])) {
				unset($new_ar['meta']['lang']);
			}
			$new_ar['metadata'] = serialize64($new_ar['meta']);
			if (!mod_data_items($new_ar)) {
			}
		}
	}

function my_snippet_breadcrumb( $lang, $link, $title, $rewrite=false )
{
	global $params, $database, $config, $ut;
	global $plugin_ar;
	if ($link) {
		$id = (int)$link;
		$tmp = array();
		for ($i=0; $i < MAX_PAGE_NEST; ++$i) {	// Page Tree 最大ネスト
			$ar2 = $database->sql_select_all("select title,link,type,block_type,mode,metadata from ".DBX."data_items where id=?", $id);
			if (!$ar2 || $ar2[0]['mode'] ==2) { break; }
			if (!$ar2[0]['title'] && isset($plugin_ar[$ar2[0]['type']])) {
				$ar2[0]['title'] = $plugin_ar[$ar2[0]['type']]['title'];
			}
			$m = unserialize64($ar2[0]['metadata']);
			if (isset($m['lang'][$lang]['title'])) {
				$ar2[0]['title'] = $m['lang'][$lang]['title'];
			}
			if ($ar2[0]['block_type'] != 5) {
				array_unshift($tmp, array( 'link'=>$ut->link($id), 'text'=>$ar2[0]['title'] ) );
			}
			if (!$ar2[0]['link']) { break; }
			$id = $ar2[0]['link'];
		}
		foreach ($tmp as $v) {
			if (isset($v['text']) && $v['text']) {
				$params['breadcrumb'][] = $v;
			}
		}
	}
	if (!$title) {
		$title = '...';
	}
	$params['breadcrumb'][] = array( 'link'=>'', 'text'=>"<a href='{$ut->link($params['page']['id'])}'>$title</a>" );
}

?>