<?php

function multi_language_page(&$page_ar)
{
	global $html,$params,$database,$config,$ut,$p_circle;
	
	$p_page = $page_ar['id'];
	
	if (isset($_SESSION['login_id']) && $params['page']['user'] != $_SESSION['login_id']) {
		// ページ作成者以外は編集不可とする
		unset($params['edit-right']);	
	}
	
	if ($page_ar['type'] == LANG_DATA_ID && $page_ar['link']) {
		header("Location: {$ut->link($page_ar['link'],"prefix:en/")}");
		exit();
	}
	
	$lang = 'jp';
	$mode = false;
	if ($params['url_prefix'] == 'en') {
		$lang = 'en';
		$ar = $database->sql_select_all( "select id from ".DBX."data_items where circle=? and type =? and link=? ", $p_circle, LANG_DATA_ID, $p_page );
		if (!$ar) {
			$r = array(); 
			$r['result'] = false; 
			$r['type'] = LANG_DATA_ID;
			$r['link'] = $p_page;
			$r['metadata']['lang'] = 'en';
			if (!create_page( $r )) {
				return "error";
			}
			$lang_id = $r['id'];
		} else {
			$lang_id = $ar[0]['id'];
		}
		snippet_breadcrumb( $page_ar['link'], "{$page_ar['title']} (english)" );
		$params['canonical'] = $ut->link($params['page']['id'],'prefix:en');
	}
	
	if (isset($_GET['mode'])) {
		if ($_GET['mode'] == 'edit') {
			$mode = 'edit';
			
		} else if ($_GET['mode'] == 'edit_en') {
			$mode = 'edit_en';
		}
	}

	if ($lang == 'en') {
		$contents_b = $page_ar['contents'];
		$title_b = $page_ar['title'];
		$mode_b = $params['page']['mode'];
		if (!(check_rights('edit') || isset($params['edit-right'])) && $mode_b == 0) {
			exit_proc(403, "This page is not published");
		}
		read_pagedata($lang_id, $params['page']);
		if (isset($params['page']['mode']) && $params['page']['mode'] == 0) {
			if (check_rights('edit') || isset($params['edit-right'])) {
				$html['information'][]='This page is currently being edited';
			} else {
$html['css']['onethird-no-translate'] = <<<EOT
				.onethird-no-translate {
					border: 1px solid #222;
					background-color: #fff;
					color:#222;
					.border-radius(6px);
					margin:10px 0;
					padding: 10px;
				}
EOT;
				$params['page']['contents'] = "<p class='onethird-no-translate'>This page has not been translated yet.</p>$contents_b";
				$params['page']['title'] = $title_b;
				$params['page']['mode'] = $mode_b;
				$tmp = basic_renderer($lang_id);
				return frame_renderer($tmp);
			}
		}
	}

	if ($mode) {
		$option = array();
		provide_edit_module();
		snippet_breadcrumb($p_page, 'Page Edit');
		$buff = page_edit_renderer($params['page'], $option);

		return frame_renderer($buff);
	}

	if ($lang == 'en') {
		$params['add-blockmenu'][] = "<input type='button' class='onethird-button mini' value='japanese' onclick='location.href=\"{$ut->link($p_page,"prefix:")}\"' />";
		$params['add-blockmenu'][] = "<input type='button' class='onethird-button mini' value='setting' onclick='ot.multi_language_setting()' />";
		$params['add-blockmenu'][] = "<input type='button' class='onethird-button mini' value='edit' onclick='location.href=\"{$ut->link($p_page,"prefix:en/","&:mode=edit")}\"' />";
		$params['add-blockmenu'][] = "<input type='button' class='onethird-button mini' value='delete' onclick='ot.remove_page($lang_id)' />";
		
		$params['hide-blockmenu'] = true;
		_multi_language_setting($lang_id, $page_ar);
		
	} else {
		$params['add-blockmenu'][] = "<input type='button' class='onethird-button mini' value='english' onclick='location.href=\"{$ut->link($p_page,"prefix:en/")}\"' />";
	}

	$tmp = basic_renderer($p_page);
	$buff = frame_renderer($tmp);

	return $buff;
}

function _multi_language_setting($lang_id, &$page_ar)
{
	global $html,$params,$database,$config,$ut,$p_circle;

	if (check_rights('edit')) {
$tmp = <<<EOT
	<div id="multi_language_setting" class='onethird-dialog' >
		<div class='title'>Multi language setting</div>
		<div class='onethird-setting'>
			<table>
				<tr>
					<td>Title</td>
					<td>
						<input type='text' name='p_multi_language_title' id='p_multi_language_title'  />
					</td>
				</tr>
				<tr>
					<td>option</td>
					<td>
						<label>
							<input type='checkbox' name='p_multi_language_publish' id='p_multi_language_publish'  />
							Publish
						</label>
					</td>
				</tr>
			</table>
		</div>
		<div class='actions' >
			<input type='button' class='onethird-button' value='OK' onclick='ot.save_multi_language_setting(this)' />
			<input type='button' class='onethird-button' value='Cancel' onclick='ot.close_dialog(this)' />
		</div>
	</div>
<script>
	ot.multi_language_setting = function (id) {
		ot.open_dialog(\$('#multi_language_setting'));
		ot.ajax({
			type: "POST"
			, url: '{$_SERVER['REQUEST_URI']}'
			, data: "ajax=multi_language_setting"
			, dataType:'json'
			, success: function(data){
				if ( data && data['result'] ) {
					\$('#p_multi_language_title').val(data['title']);
					\$('#p_multi_language_publish').prop('checked',data['publish']);
				}
			}
		});
	}
	ot.save_multi_language_setting = function (obj) {
		var a = '&title='+encodeURIComponent(\$('#p_multi_language_title').val());
		if (\$('#p_multi_language_publish:checked').length) {
			a += "&publish=true";
		}
		ot.ajax({
			type: "POST"
			, url: '{$_SERVER['REQUEST_URI']}'
			, data: "ajax=save_multi_language_setting"+a
			, dataType:'json'
			, obj:obj
			, success: function(data){
				if ( data && data['result'] ) {
					location.reload(true);
				}
			}
		});
	}
	ot.remove_multi_language_setting = function (obj) {
		if (!confirm('Are you sure you want to delete translated data?')) {
			return;
		}
		ot.ajax({
			type: "POST"
			, url: '{$_SERVER['REQUEST_URI']}'
			, data: "ajax=remove_multi_language_setting"
			, dataType:'json'
			, obj:obj
			, success: function(data){
				if ( data && data['result'] ) {
					location.reload(true);
				}
			}
		});
	}
	
</script>
EOT;
		$html['meta'][] = $tmp;
	}

	if (isset($_POST['ajax']) && $_POST['ajax'] == 'multi_language_setting')  {
		$r = array();
		$r['result'] = false;
		$r['id'] = $lang_id;
		$ar = $database->sql_select_all("select title,mode from ".DBX."data_items where id=?", $lang_id);
		if ($ar && $ar[0]['title']) {
			$r['result'] = true;
			$r['title'] = $ar[0]['title'];
			$r['publish'] = $ar[0]['mode']==1;
		}
		echo(json_encode($r));
		exit();
	}

	if (isset($_POST['ajax']) && $_POST['ajax'] == 'save_multi_language_setting')  {
		$r = array();
		$r['result'] = false;
		$r['id'] = $lang_id;
		if (isset($_POST['title'])) {
			$title = sanitize_str($_POST['title']);
			if (isset($_POST['publish'])) {
				$mode = 1;
			} else {
				$mode = 0;
			}
			if ($database->sql_update( "update ".DBX."data_items set title=?, mode=? where id=?", $title, $mode, $lang_id)) {
				$r['result'] = true;
			}
		}
		echo(json_encode($r));
		exit();
	}

}

?>